<?php

use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;
use Slim\Factory\AppFactory;

require __DIR__ . '/../vendor/autoload.php';
require __DIR__ . '/../src/db.php';
require __DIR__ . '/../src/authMiddleware.php';

$app = AppFactory::create();
$app->addBodyParsingMiddleware();

$API_KEY = '1234567890'; // Replace with your secure API key

// Grouped routes with auth middleware
$app->group('', function ($group) {
    // Create Lead
    $group->post('/lead', function (Request $request, Response $response) {
        $data = $request->getParsedBody();
        $db = getDB();
        $stmt = $db->prepare("INSERT INTO leads ('fname','mname','lname','pa_fname','pa_lname','email','phone','mobile','nationality','education','profession','address','no_of_applicants','dob','gender','country_interest','sub_country_interest','service_interest','market_source','sub_market_source','appointment','followup','folowuptime','enquiry','ref_remark','convet','priority','regdate','regtime','assignTo','case_officer','lead_quality','type','branch','region','Counsilor','last_updated','last_updtd_time','exist',,'transfered_by','area','alert','created','created_by') VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        $stmt->execute([$data['fname'], $data['mname'], $data['lname'], $data['pa_fname'], $data['pa_lname'], trim($data['email']), $data['phone'], $data['mobile'], $data['nationality'], $data['education'], $data['occupation'], $data['address'], $data['no_of_applicants'], $dob, $data['gender'], $country, $subcountry, $data['service_interest'], $source, $subsource, $appointment, date('Y-m-d',strtotime($data['followup'])), $the_time, $data['enquiry'], $data['ref_remark'], $data['convet'], $data['priority']!='' ? $data['priority'] : 'N/A', date('Y-m-d'), date('H:i:s'), $data['assign'], $data['assign'], $data['lead_quality'], $data['type'], ($bk1['id']!='' && $bk1['id']!=0) ? $bk1['id'] :  $emp1['branch'], ($bk1['region']!='' && $bk1['region']!=0) ? $bk1['region'] :  $emp1['region'], $data['assign'], date('d-m-Y h-i-sa'), date('h-i-sa'), $exist, $_SESSION['ID'], $data['area'], $alert, date('Y-m-d h:i:s'), $_SESSION['ID']]);
        $response->getBody()->write(json_encode(['status' => 'Lead Created']));
        return $response->withHeader('Content-Type', 'application/json');
    });

    // Create Payment
    $group->post('/payment', function (Request $request, Response $response) {
        $data = $request->getParsedBody();
        $db = getDB();
        $stmt = $db->prepare("INSERT INTO payments (lead_id, amount, status) VALUES (?, ?, ?)");
        $stmt->execute([$data['lead_id'], $data['amount'], $data['status']]);
        $response->getBody()->write(json_encode(['status' => 'Payment Created']));
        return $response->withHeader('Content-Type', 'application/json');
    });

    // Update Payment
    $group->put('/payment/{id}', function (Request $request, Response $response, $args) {
        $data = $request->getParsedBody();
        $db = getDB();
        $stmt = $db->prepare("UPDATE payments SET amount = ?, status = ? WHERE id = ?");
        $stmt->execute([$data['amount'], $data['status'], $args['id']]);
        $response->getBody()->write(json_encode(['status' => 'Payment Updated']));
        return $response->withHeader('Content-Type', 'application/json');
    });
})->add(authMiddleware($API_KEY)); // 🔒 Authentication applied

$app->run();
